%%%% plot uDOF and spatial efficiency for different array geometries
%%%% by stone
%%%% 2020.08.28
clear all;
close all;
%close all;
array_number_change = 21;
wavelength = 1; % normalized
d = wavelength / 2;

designs_number = 11;
uDOF_record = zeros(designs_number,array_number_change);
spatial_efficiency_record = zeros(designs_number,array_number_change);
for ii = 1:array_number_change  
       antenna_number = 17+ii*3;
       antenna_amount (ii,1) = antenna_number;       
       design_ana11 = ana11_1d(antenna_number, d);
       design_ana12 = ana11_1d(antenna_number, d);     
       design_nested = nested_1d(antenna_number, d);
       design_supernested_2 = super_nested_1d(antenna_number, 2,d,'Super Nested Q = 2');
       design_supernested_3 = super_nested_1d(antenna_number, 3,d,'Super Nested Q = 3');
       design_MISC = MISC_1d(antenna_number, d);      
       design_ATLI_1BL = ATLI_1BL_1d(antenna_number, d);       
       design_ATLI_2BL = ATLI_2BL_1d(antenna_number, d);    
       design_TSENA = tsena_1d(antenna_number, d);          
       design_ATLI_2BL = ATLI_2BL_1d(antenna_number, d); 
       design_UF_3BL = UF_3BLC1(antenna_number, d);      
       design_UF_4BL = UF_4BLC1(antenna_number, d);       
       
    designs = { ...
    design_MISC,...
    design_UF_3BL,...
    design_UF_4BL,...
    design_nested,...
    design_supernested_2,...
    design_supernested_3,...
    design_ana11,...
    design_ana12,...
    design_ATLI_1BL,...
    design_ATLI_2BL,...
    design_TSENA,...
};

for bb = 1:designs_number
    design = designs{bb};
    arr_indices = design.element_indices;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%     compute diff     %%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    arr_indices = arr_indices(:);
diffs = [];
w = [];
index_map = {};
if isempty(arr_indices)
    return;
end
n = length(arr_indices);
P = repmat(arr_indices', n, 1);
D = P' - P; % D_ij = d_i - d_j
[all_diffs, idx] = sort(D(:));
cur_diff = all_diffs(1);
start_idx = 1;
jj = 1;
for ee = 2:(n*n)
    if all_diffs(ee) ~= cur_diff
        diffs(jj) = cur_diff;
        index_map{jj} = idx(start_idx:ee-1);
        w(jj) = ee - start_idx;
        start_idx = ee;
        cur_diff = all_diffs(ee);
        jj = jj + 1;
    end
end
% add the last one
diffs(jj) = cur_diff;
aperture = max(diffs);
[s, m_v, zero_idx] = get_central_ula_size(diffs);
uDOF = s;
half_uDOF = m_v-1;
spatial_efficiency = half_uDOF/aperture;
uDOF_record(bb,ii)=s;
spatial_efficiency_record(bb,ii)=spatial_efficiency;
end
end 
figure(1)
%sensor_number = num2str(antenna_number);
markers = {'+', 'o', 'd', '*','s','^','h','p','x','>', '+', 'o', 'd', '*','s','^','h','p','x','>','+', 'o', 'd', '*','s','^','h','p','x','>'};
colors  = {'k','b','r','g','m','c','k','b','r','g','m','c','k','b','r','g','m','c','k','b','r','g','m','c'};
lines = {'-',':','-.','--','-',':','-.','--','-',':','-.','--','-',':','-.','--'};
res_legends0 = {};
res_legends1 = {};
res_legends2 = {};
res_legends3 = {};
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%plot difference geometries MSE
figure(1);
for dd = 1:designs_number
    plot(antenna_amount, uDOF_record(dd,:), ['-' markers{dd} colors{dd}]);
    hold on;
    res_legends1 = [res_legends1 [designs{dd}.name 'MSE'] ]; 
end

xlabel('Sensor Amount'); ylabel('uDOF'); grid on;

legend(res_legends1{:});

title(' uDOF versus sensor amount ');

figure(2);
for cc = 1:designs_number
    plot(antenna_amount, spatial_efficiency_record(cc,:), ['-' markers{cc} colors{cc}]);
    hold on;
    res_legends2 = [res_legends2 [designs{cc}.name 'MSE'] ]; 
end

xlabel('Sensor Amount'); ylabel('Spatial efficiency'); grid on;

legend(res_legends2{:});

title(' Spatial efficiency versus sensor amount ');

function [s, m_v, zero_idx] = get_central_ula_size(diffs)

if isstruct(diffs)
    diffs = unique_differences(diffs.element_indices);
end

w = 0;
zero_idx = find(diffs == 0);
n_diff = length(diffs);
while zero_idx + w < n_diff && zero_idx - w > 1
    w = w + 1;
    if (diffs(zero_idx+w) - diffs(zero_idx+w-1) ~= 1) || (diffs(zero_idx-w+1) - diffs(zero_idx-w)) ~= 1
        w = w - 1;
        break;
    end
end
m_v = w + 1;
s = 2*m_v - 1;

end